Option EXPLICIT
Option BASE 0
Option AUTORUN ON

Const BG_COL = RGB(BLACK)
Const FG_COL = RGB(WHITE)
Const FADE_COL = RGB(128,128,128)
Const BUTTON_COL = RGB(CYAN)
Const ERROR_COLOUR = RGB(RED)
Const HL_COLOUR = RGB(BLACK)
Const AXIS_COLOUR = RGB(128,128,128)
Const AXIS_LEFT = 34
Const AXIS_RIGHT = 286
Const AXIS_TOP = 36
Const AXIS_BOTTOM = 190
Const V_COLOUR = RGB(RED)
Const I1_COLOUR = RGB(YELLOW)
Const I2_COLOUR = RGB(GREEN)
Const I3_COLOUR = RGB(CYAN)
Const I4_COLOUR = RGB(BLUE)


Dim Integer ON_BL
Dim Integer IDLE_BL
Dim Integer MN_TMOUT
Const IDLE_TIMEOUT = 5000
Dim INTEGER DISPLAY_TIMEOUT
ON_BL = 70
IDLE_BL = 5
MN_TMOUT = 55000








Const ADC_CS=24
Dim FLOAT V_CAL(5)
V_CAL(1)=100/16777216
V_CAL(2)=V_CAL(1)
V_CAL(3)=V_CAL(1)
V_CAL(4)=V_CAL(1)

SetPin ADC_CS,DOUT
Pin(ADC_CS)=1
Const ADC_TIMEOUT = 1200


Const SHUNT_ADC=4
SetPin SHUNT_ADC,AIN
Dim FLOAT I_CAL(5)
I_CAL(1) = -1/(100*0.1)
I_CAL(2) = -1/0.015
I_CAL(3) = -1/0.015
I_CAL(4) = -1/0.015

Dim FLOAT I_RATIO(5)

I_RATIO(2)=1
I_RATIO(3)=1
I_RATIO(4)=1


Const BUTTON_COUNT = 30
Dim Integer key_coord(BUTTON_COUNT, 5)
Dim String key_caption(BUTTON_COUNT)
Dim INTEGER BUTTON_PRESS

Const SMOOTHING_FACTOR = 0






Dim FLOAT NEW_RAW(10)
NEW_RAW(0)=0
NEW_RAW(1)=-1
NEW_RAW(2)=0
NEW_RAW(3)=0
NEW_RAW(4)=0
NEW_RAW(5)=0
NEW_RAW(6)=0
NEW_RAW(7)=0
NEW_RAW(8)=0
NEW_RAW(9)=0

Dim INTEGER RAW_ACTUAL(6)
RAW_ACTUAL(0)=0
RAW_ACTUAL(1)=-1
RAW_ACTUAL(2)=0
RAW_ACTUAL(3)=0
RAW_ACTUAL(4)=0
RAW_ACTUAL(5)=0


Dim FLOAT ACTUAL(6)
ACTUAL(0)=0
ACTUAL(1)=0
ACTUAL(2)=0
ACTUAL(3)=0
ACTUAL(4)=0
ACTUAL(5)=0


Dim FLOAT V_FULL,V_EMPTY,I_SCALE,V_SHUTDOWN

V_FULL=14.4
V_EMPTY=11.0
V_SHUTDOWN=10.5
I_SCALE=20


Dim FLOAT AH_SINCEF, AH_SINCEE, WH_SINCEF, WH_SINCEE
Dim INTEGER USAGE_STATE
AH_SINCEF=0
AH_SINCEE=0
WH_SINCEF=0
WH_SINCEE=0
USAGE_STATE=0


Const S_COUNT = 720
Const H_COUNT = 48
Const D_COUNT = 17
Dim INTEGER SAMPLE_STATE, SAMPLE_PTR
SAMPLE_STATE=0
SAMPLE_PTR=0

Dim INTEGER D_START, D_PTR
Dim INTEGER H_START, H_PTR
D_PTR=0
H_PTR=0

D_START=0
H_START=0
Dim FLOAT SAMPLES(5,S_COUNT)
Dim FLOAT H_SAMP(5,H_COUNT)
Dim FLOAT D_SAMP(5,D_COUNT)


Dim I As INTEGER


For I = 0 To S_COUNT-1
SAMPLES(0,I)=-1
SAMPLES(1,I)=0
SAMPLES(2,I)=0
SAMPLES(3,I)=0
SAMPLES(4,I)=0
Next I
For I = 0 To H_COUNT-1
H_SAMP(0,I)=-1
H_SAMP(1,I)=0
H_SAMP(2,I)=0
H_SAMP(3,I)=0
H_SAMP(4,I)=0
Next I
For I = 0 To D_COUNT-1
D_SAMP(0,I)=-1
D_SAMP(1,I)=0
D_SAMP(2,I)=0
D_SAMP(3,I)=0
D_SAMP(4,I)=0
Next I


Dim INTEGER DISPLAYSTATE
DISPLAYSTATE=2


Dim INTEGER DISP_NUM


VAR RESTORE
VAR SAVE H_SAMP(),D_SAMP(),D_START, D_PTR,H_START, H_PTR, V_CAL(), I_CAL(),ON_BL,IDLE_BL,MN_TMOUT,V_EMPTY,V_FULL,AH_SINCEF, AH_SINCEE, WH_SINCEF, WH_SINCEE,I_SCALE,V_SHUTDOWN

LCD_ON
CLS (BG_COL)
SET_BACKLIGHT(ON_BL)

On ERROR IGNORE
RTC GETTIME
On ERROR ABORT
DISPLAY_TIMEOUT=Timer

DRAW_MAIN
Do

SAMPLE_MANAGER
SAMPLE_MANAGER



If DISPLAYSTATE>0 Then

Text 280,0,Right$("   "+Str$(Int(((MN_TMOUT+IDLE_TIMEOUT)-(Timer-DISPLAY_TIMEOUT))\1000)),3),LT,1,1,FG_COL,BG_COL


If CHECK_SCREEN_TOUCH()=1 Then
DISPLAY_TIMEOUT=Timer
If DISPLAYSTATE<2 Then
DISPLAYSTATE=2
SET_BACKLIGHT(ON_BL)
EndIf
EndIf
BUTTON_PRESS=CheckButtonPress(0, 2)
If BUTTON_PRESS >= 0 Then

DISPLAYSTATE=2
SET_BACKLIGHT(ON_BL)
If BUTTON_PRESS=0 Then
CheckButtonRelease(0)
DATA_MENU
EndIf
If BUTTON_PRESS=1 Then
CheckButtonRelease(0)
SETTINGS_MENU
EndIf
If BUTTON_PRESS=2 Then
CheckButtonRelease(0)
CALIBRATE_MENU
EndIf
EndIf

Text 160,68,"   "+Date$+" "+Time$+"   ",CT,1,1,FG_COL,BG_COL
If RAW_ACTUAL(1)<0 Then
Text 45,84,"ERROR",CT,1,1,ERROR_COLOUR,BG_COL
Else
Text 45,84,"  OK  ",CT,1,1,FG_COL,BG_COL
EndIf
Text 4,100,"V="+Str$(ACTUAL(1), 5, 2)+"V",LT,1,1,FG_COL,BG_COL
Text 4,116,"I1="+Str$(ACTUAL(2), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
Text 4,132,"I2="+Str$(ACTUAL(3), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
Text 4,148,"I3="+Str$(ACTUAL(4), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
Text 4,164,"I4="+Str$(ACTUAL(5), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
If V_FULL - V_EMPTY > 0.1 Then
DISP_NUM = ((ACTUAL(1)-V_EMPTY)*100)/(V_FULL - V_EMPTY)
If DISP_NUM<0 Then DISP_NUM=0
If DISP_NUM>100 Then DISP_NUM=100
Text 112,84,"CHGv="+Str$(DISP_NUM, 3, 0)+"%",LT,1,1,FG_COL,BG_COL
Else
Text 112,84,"CHGv=---%",LT,1,1,ERROR_COLOUR,BG_COL
EndIf

Text 112,116,"Ah since full= "+Str$(AH_SINCEF, 6, 1)+"Ah",LT,1,1,FG_COL,BG_COL
Text 112,132,"Ah since empty="+Str$(AH_SINCEE, 6, 1)+"Ah",LT,1,1,FG_COL,BG_COL
Text 112,148,"Wh since full= "+Str$(WH_SINCEF, 6, 1)+"Wh",LT,1,1,FG_COL,BG_COL
Text 112,164,"Wh since empty="+Str$(WH_SINCEE, 6, 1)+"Wh",LT,1,1,FG_COL,BG_COL

DISP_NUM=0



If (WH_SINCEF-WH_SINCEE)>0.1 Then DISP_NUM = (-WH_SINCEE*100)/(WH_SINCEF-WH_SINCEE)
If DISP_NUM<0 Then DISP_NUM=0
If DISP_NUM>100 Then DISP_NUM=100
If USAGE_STATE>2 Then
Text 200,84,"CAP="+Str$(AH_SINCEF-AH_SINCEE, 6, 1)+"Ah",LT,1,1,FG_COL,BG_COL
Text 200,100,"CAP="+Str$(WH_SINCEF-WH_SINCEE, 6, 1)+"Wh",LT,1,1,FG_COL,BG_COL
Text 112,100,"CHGm="+Str$(DISP_NUM, 3, 0)+"%",LT,1,1,FG_COL,BG_COL
Else
Text 200,84,"CAP="+Str$(AH_SINCEF-AH_SINCEE, 6, 1)+"Ah",LT,1,1,FADE_COL,BG_COL
Text 200,100,"CAP="+Str$(WH_SINCEF-WH_SINCEE, 6, 1)+"Wh",LT,1,1,FADE_COL,BG_COL
Text 112,100,"CHGm="+Str$(DISP_NUM, 3, 0)+"%",LT,1,1,FADE_COL,BG_COL
EndIf


If (DISPLAYSTATE > 1) And ((Timer-DISPLAY_TIMEOUT)>MN_TMOUT) Then
DISPLAYSTATE=1
SET_BACKLIGHT(IDLE_BL)
EndIf

If ((Timer-DISPLAY_TIMEOUT)>MN_TMOUT+IDLE_TIMEOUT) Then
DISPLAYSTATE=0
SET_BACKLIGHT(0)
LCD_OFF
EndIf
Pause 50
Else
If ACTUAL(1)> V_SHUTDOWN Then
CPU SLEEP 1
Else
CPU SLEEP 15
EndIf
If CHECK_SCREEN_TOUCH()=1 Then
DISPLAY_TIMEOUT=Timer
DISPLAYSTATE=2
LCD_ON
CLS (BG_COL)
SET_BACKLIGHT(ON_BL)
WAIT_FOR_RELEASE
DRAW_MAIN
EndIf
EndIf
Loop
WatchDog 1
End

Sub CALIBRATE_MENU
DRAW_CALIBRATE
Do
SAMPLE_MANAGER
BUTTON_PRESS=CheckButtonPress(0, 5)
If BUTTON_PRESS >= 0 Then
CheckButtonRelease(BUTTON_PRESS)
If BUTTON_PRESS = 0 Then
If OK_CANCEL_BOX("ENSURE NO LOAD","ON TERMINALS")>0 Then DO_V_CAL
DRAW_CALIBRATE
EndIf
If (BUTTON_PRESS >=1) And (BUTTON_PRESS <=4) Then
DO_I_CAL(BUTTON_PRESS)
DRAW_CALIBRATE
EndIf
If BUTTON_PRESS = 5 Then Exit Do
EndIf
Loop
DRAW_MAIN
End Sub

Sub SETTINGS_MENU
DRAW_SETTINGS
Local FLOAT NUM
Do
Text 160,30,"   "+Date$+" "+Time$+"   ",CT,1,1,FG_COL,BG_COL
SAMPLE_MANAGER
BUTTON_PRESS=CheckButtonPress(0, 13)
If BUTTON_PRESS >= 0 Then
CheckButtonRelease(BUTTON_PRESS)
If BUTTON_PRESS = 0 Then
NUM=NUMBERPAD("Enter year:")
If NUM >= 2000 Then SET_RTC(0,NUM)
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 1 Then
NUM=NUMBERPAD("Enter month:")
If (NUM >= 1) And (NUM <= 12) Then SET_RTC(1,NUM)
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 2 Then
NUM=NUMBERPAD("Enter day number:")
If (NUM >= 1) And (NUM <= 31) Then SET_RTC(2,NUM)
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 3 Then
NUM=NUMBERPAD("Enter hour (24):")
If (NUM >= 1) And (NUM <= 24) Then SET_RTC(3,NUM)
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 4 Then
NUM=NUMBERPAD("Enter minute:")
If (NUM >= 1) And (NUM <= 60) Then SET_RTC(4,NUM)
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 5 Then
NUM=NUMBERPAD("Enter second:")
If (NUM >= 1) And (NUM <= 60) Then SET_RTC(5,NUM)
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 6 Then
NUM=NUMBERPAD("Enter Backlight%:")
If (NUM >= 1) And (NUM <= 100) Then ON_BL=NUM:SET_BACKLIGHT(ON_BL):VAR SAVE ON_BL
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 9 Then
NUM=NUMBERPAD("Enter Backlight%:")
If (NUM >= 1) And (NUM <= 100) Then IDLE_BL=NUM:VAR SAVE IDLE_BL
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 8 Then
NUM=NUMBERPAD("Enter timeout(s):")
If (NUM*1000 > IDLE_TIMEOUT) Then MN_TMOUT=NUM*1000-IDLE_TIMEOUT : VAR SAVE MN_TMOUT
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 7 Then
NUM=NUMBERPAD("Enter V(full):")
If (NUM>=5) And (NUM>V_EMPTY) And (NUM>V_SHUTDOWN) Then
V_FULL=NUM
VAR SAVE V_FULL
Else
MessageBox("V(full) too low","Check and retry")
EndIf
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 10 Then
NUM=NUMBERPAD("Enter V(empty):")
If (NUM>=5) And (NUM<V_FULL) And (NUM>V_SHUTDOWN) Then
V_EMPTY=NUM
VAR SAVE V_EMPTY
Else
MessageBox("V(empty) too low","or above V(full)")
EndIf
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 12 Then
NUM=NUMBERPAD("Enter I(scale):")
If (NUM>=1) Then
I_SCALE=NUM
VAR SAVE I_SCALE
Else
MessageBox("I(scale)","too low")
EndIf
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 13 Then
NUM=NUMBERPAD("Enter V(shutdown):")
If ((NUM >= 0) And (NUM<V_EMPTY)) Then
V_SHUTDOWN=NUM
VAR SAVE V_SHUTDOWN
Else
MessageBox("V(shutdown)","too high")
EndIf
DRAW_SETTINGS
EndIf
If BUTTON_PRESS = 11 Then Exit Do
EndIf
Loop
DRAW_MAIN
End Sub

Sub SET_RTC(S As INTEGER, P As INTEGER)
Local INTEGER T(6)
T(0)=Val(Mid$(Date$,7,4))
T(1)=Val(Mid$(Date$,4,2))
T(2)=Val(Mid$(Date$,1,2))
T(3)=Val(Mid$(Time$,1,2))
T(4)=Val(Mid$(Time$,4,2))
T(5)=Val(Mid$(Time$,7,2))
If (S>=0) And (S<=5) Then T(S)=P
On ERROR IGNORE
RTC SETTIME T(0),T(1),T(2),T(3),T(4),T(5)
On ERROR ABORT
End Sub

Sub DATA_MENU
Local INTEGER GRAPH_MODE
Local INTEGER UPDATE_TIME
UPDATE_TIME=Timer
GRAPH_MODE=0
DRAW_DATA
DRAW_GRAPH(GRAPH_MODE)
Do
SAMPLE_MANAGER
BUTTON_PRESS=CheckButtonPress(0, 4)
If BUTTON_PRESS >= 0 Then
CheckButtonRelease(BUTTON_PRESS)
If BUTTON_PRESS < 3 Then GRAPH_MODE=BUTTON_PRESS: DRAW_GRAPH(GRAPH_MODE): UPDATE_TIME=Timer
If BUTTON_PRESS = 3 Then Exit Do
If BUTTON_PRESS = 4 Then EXPORT_DATA(GRAPH_MODE)
EndIf

If (Timer - UPDATE_TIME) > 60000 Then DRAW_GRAPH(GRAPH_MODE): UPDATE_TIME=Timer
Loop
DRAW_MAIN
End Sub

Sub DRAW_GRAPH(N As INTEGER)
Local INTEGER I

Box 0,AXIS_TOP,319,AXIS_BOTTOM-AXIS_TOP+1,,BG_COL,BG_COL

Line AXIS_LEFT,AXIS_TOP,AXIS_RIGHT,AXIS_TOP,1,AXIS_COLOUR
Line AXIS_LEFT,AXIS_TOP,AXIS_LEFT,AXIS_BOTTOM,1,AXIS_COLOUR
Line AXIS_LEFT,AXIS_BOTTOM,AXIS_RIGHT,AXIS_BOTTOM,1,AXIS_COLOUR
Line AXIS_RIGHT,AXIS_TOP,AXIS_RIGHT,AXIS_BOTTOM,1,AXIS_COLOUR
Line AXIS_LEFT,(AXIS_TOP+AXIS_BOTTOM)\2,AXIS_RIGHT,(AXIS_TOP+AXIS_BOTTOM)\2,1,AXIS_COLOUR

Text AXIS_RIGHT+2,AXIS_TOP,Str$(V_FULL, 2, 1),LT,,1,V_COLOUR,BG_COL
Text AXIS_RIGHT+2,AXIS_BOTTOM,Str$(V_EMPTY, 2, 1),LB,,1,V_COLOUR,BG_COL
Text AXIS_RIGHT+2,(AXIS_TOP+AXIS_BOTTOM)\2,"V",LM,,1,V_COLOUR,BG_COL

Text AXIS_LEFT-1,AXIS_TOP,Str$(I_SCALE, 2,0),RT,,1,I2_COLOUR,BG_COL
Text AXIS_LEFT-1,AXIS_BOTTOM,Str$(-I_SCALE, 2,0),RB,,1,I2_COLOUR,BG_COL
Text AXIS_LEFT-1,(AXIS_TOP+AXIS_BOTTOM)\2-20,"I1",RM,,1,I1_COLOUR,BG_COL
Text AXIS_LEFT-1,(AXIS_TOP+AXIS_BOTTOM)\2,"I2",RM,,1,I2_COLOUR,BG_COL
Text AXIS_LEFT-1,(AXIS_TOP+AXIS_BOTTOM)\2+20,"I3",RM,,1,I3_COLOUR,BG_COL
Text AXIS_LEFT-1,(AXIS_TOP+AXIS_BOTTOM)\2+40,"I4",RM,,1,I4_COLOUR,BG_COL

Text AXIS_RIGHT,AXIS_BOTTOM+2,"NOW",RT,,1,AXIS_COLOUR,BG_COL
If N = 0 Then
Text AXIS_LEFT,AXIS_BOTTOM+2,"-60 minutes",LT,,1,AXIS_COLOUR,BG_COL
For I = 0 To S_COUNT-1

If SAMPLES(1,((SAMPLE_STATE+I+1) Mod 720))>0 Then
DRAW_SAMPLE_PIXELS(AXIS_LEFT+((AXIS_RIGHT-AXIS_LEFT)*I)\S_COUNT,((SAMPLE_STATE+I+1) Mod 720))
End If
Next I
EndIf
If N = 1 Then
Text AXIS_LEFT,AXIS_BOTTOM+2,"-48 hours  ",LT,,1,AXIS_COLOUR,BG_COL
DRAW_HOUR_LINES
EndIf
If N = 2 Then
Text AXIS_LEFT,AXIS_BOTTOM+2,Str$(-D_COUNT)+" days    ",LT,,1,AXIS_COLOUR,BG_COL
DRAW_DAY_LINES
EndIf
End Sub

Sub DRAW_HOUR_LINES
Local INTEGER I,J
Local INTEGER X(H_COUNT),Y(6,H_COUNT)
For I = 0 To H_COUNT-1

If H_SAMP(1,I) > 0 Then
Y(1,I)=AXIS_BOTTOM+(H_SAMP(1,I)-V_EMPTY)*(AXIS_BOTTOM-AXIS_TOP)/(V_EMPTY-V_FULL)
If Y(1,I) < AXIS_TOP+1 Then Y(1,I) = AXIS_TOP+1
If Y(1,I) > AXIS_BOTTOM-1 Then Y(1,I) = AXIS_BOTTOM-1
For J = 2 To 5
Y(J,I)=(AXIS_BOTTOM+AXIS_TOP)\2 + H_SAMP(J,I)*(AXIS_BOTTOM-AXIS_TOP)/(2*I_SCALE)
If Y(J,I) < AXIS_TOP+1 Then Y(J,I) = AXIS_TOP+1
If Y(J,I) > AXIS_BOTTOM-1 Then Y(J,I) = AXIS_BOTTOM-1
Next J
EndIf

X(I)= AXIS_LEFT + ((I + H_COUNT - H_PTR)*(AXIS_RIGHT-AXIS_LEFT))/H_COUNT-1
If (X(I) < AXIS_LEFT) Or (X(I) > AXIS_RIGHT) Then X(I)=0
Next I

For I = 0 To H_COUNT-2
If (X(I)>0) And (X(I+1)>0) And (Y(1,I)>0)And (Y(1,I+1)>0) Then
Line X(I),Y(1,I),X(I+1),Y(1,I+1),1,V_COLOUR
Line X(I),Y(2,I),X(I+1),Y(2,I+1),1,I1_COLOUR
Line X(I),Y(3,I),X(I+1),Y(3,I+1),1,I2_COLOUR
Line X(I),Y(4,I),X(I+1),Y(4,I+1),1,I3_COLOUR
Line X(I),Y(5,I),X(I+1),Y(5,I+1),1,I4_COLOUR
EndIf
Next I
End Sub

Sub DRAW_DAY_LINES
Local INTEGER I,J
Local INTEGER X(D_COUNT),Y(6,D_COUNT)
For I = 0 To D_COUNT-1

If D_SAMP(1,I) > 0 Then
Y(1,I)=AXIS_BOTTOM+(D_SAMP(1,I)-V_EMPTY)*(AXIS_BOTTOM-AXIS_TOP)/(V_EMPTY-V_FULL)
If Y(1,I) < AXIS_TOP+1 Then Y(1,I) = AXIS_TOP+1
If Y(1,I) > AXIS_BOTTOM-1 Then Y(1,I) = AXIS_BOTTOM-1
For J = 2 To 5
Y(J,I)=(AXIS_BOTTOM+AXIS_TOP)\2 + D_SAMP(J,I)*(AXIS_BOTTOM-AXIS_TOP)/(2*I_SCALE)
If Y(J,I) < AXIS_TOP+1 Then Y(J,I) = AXIS_TOP+1
If Y(J,I) > AXIS_BOTTOM-1 Then Y(J,I) = AXIS_BOTTOM-1
Next J
EndIf

X(I)= AXIS_LEFT + ((I + D_COUNT - D_PTR)*(AXIS_RIGHT-AXIS_LEFT))/D_COUNT-1
If (X(I) < AXIS_LEFT) Or (X(I) > AXIS_RIGHT) Then X(I)=0
Next I

For I = 0 To D_COUNT-2
If (X(I)>0) And (X(I+1)>0) And (Y(1,I)>0)And (Y(1,I+1)>0) Then
Line X(I),Y(1,I),X(I+1),Y(1,I+1),1,V_COLOUR
Line X(I),Y(2,I),X(I+1),Y(2,I+1),1,I1_COLOUR
Line X(I),Y(3,I),X(I+1),Y(3,I+1),1,I2_COLOUR
Line X(I),Y(4,I),X(I+1),Y(4,I+1),1,I3_COLOUR
Line X(I),Y(5,I),X(I+1),Y(5,I+1),1,I4_COLOUR
EndIf
Next I
End Sub

Sub DRAW_SAMPLE_PIXELS(X As INTEGER,N As INTEGER)
Local INTEGER Y


Y=AXIS_BOTTOM+(SAMPLES(1,N)-V_EMPTY)*(AXIS_BOTTOM-AXIS_TOP)/(V_EMPTY-V_FULL)
If Y < AXIS_TOP+1 Then Y = AXIS_TOP+1
If Y > AXIS_BOTTOM-1 Then Y = AXIS_BOTTOM-1
Pixel X,Y,V_COLOUR

Y=(AXIS_BOTTOM+AXIS_TOP)\2 + SAMPLES(2,N)*(AXIS_BOTTOM-AXIS_TOP)/(2*I_SCALE)
If Y < AXIS_TOP+1 Then Y = AXIS_TOP+1
If Y > AXIS_BOTTOM-1 Then Y = AXIS_BOTTOM-1
Pixel X,Y,I1_COLOUR

Y=(AXIS_BOTTOM+AXIS_TOP)\2 + SAMPLES(3,N)*(AXIS_BOTTOM-AXIS_TOP)/(2*I_SCALE)
If Y < AXIS_TOP+1 Then Y = AXIS_TOP+1
If Y > AXIS_BOTTOM-1 Then Y = AXIS_BOTTOM-1
Pixel X,Y,I2_COLOUR

Y=(AXIS_BOTTOM+AXIS_TOP)\2 + SAMPLES(4,N)*(AXIS_BOTTOM-AXIS_TOP)/(2*I_SCALE)
If Y < AXIS_TOP+1 Then Y = AXIS_TOP+1
If Y > AXIS_BOTTOM-1 Then Y = AXIS_BOTTOM-1
Pixel X,Y,I3_COLOUR

Y=(AXIS_BOTTOM+AXIS_TOP)\2 + SAMPLES(5,N)*(AXIS_BOTTOM-AXIS_TOP)/(2*I_SCALE)
If Y < AXIS_TOP+1 Then Y = AXIS_TOP+1
If Y > AXIS_BOTTOM-1 Then Y = AXIS_BOTTOM-1
Pixel X,Y,I4_COLOUR
End Sub

Sub EXPORT_DATA(N As INTEGER)
If N = 0 Then EXPORT_HOURS
If N = 1 Then EXPORT_DAYS
If N = 2 Then EXPORT_WEEKS
End Sub

Sub EXPORT_HOURS
Local INTEGER I
Local INTEGER START_TIME
START_TIME = (TIME_SERIAL()\5)*5-3600
Print "Silicon Chip Battery Multi-Logger Hours Data Export"
Print "Time,Voltage(V),Current 1 (A),Current 2 (A),Current 3 (A),Current 4 (A)"
For I = 0 To S_COUNT-1
If SAMPLES(1,((SAMPLE_STATE+I+1) Mod 720))>0 Then
Print DATE_TIME_STRING(START_TIME+I*5);",";
Print Str$(SAMPLES(1,((SAMPLE_STATE+I+1) Mod 720)));",";
Print Str$(SAMPLES(2,((SAMPLE_STATE+I+1) Mod 720)));",";
Print Str$(SAMPLES(3,((SAMPLE_STATE+I+1) Mod 720)));",";
Print Str$(SAMPLES(4,((SAMPLE_STATE+I+1) Mod 720)));",";
Print Str$(SAMPLES(5,((SAMPLE_STATE+I+1) Mod 720)))
EndIf
Next I
End Sub

Sub EXPORT_DAYS
Local INTEGER I
Local INTEGER START_TIME
START_TIME = H_START*3600
Print "Silicon Chip Battery Multi-Logger Days Data Export"
Print "Time,Voltage(V),Current 1 (A),Current 2 (A),Current 3 (A),Current 4 (A)"
For I = 0 To H_COUNT-1
If H_SAMP(1,I)>0 Then
Print DATE_TIME_STRING(START_TIME+I*3600);",";
Print Str$(H_SAMP(1,I));",";
Print Str$(H_SAMP(2,I));",";
Print Str$(H_SAMP(3,I));",";
Print Str$(H_SAMP(4,I));",";
Print Str$(H_SAMP(5,I))
EndIf
Next I
End Sub

Sub EXPORT_WEEKS
Local INTEGER I
Local INTEGER START_TIME
START_TIME = D_START*86400
Print "Silicon Chip Battery Multi-Logger Weeks Data Export"
Print "Time,Voltage(V),Current 1 (A),Current 2 (A),Current 3 (A),Current 4 (A)"
For I = 0 To D_COUNT-1
If D_SAMP(1,I)>0 Then
Print DATE_TIME_STRING(START_TIME+I*86400);",";
Print Str$(D_SAMP(1,I));",";
Print Str$(D_SAMP(2,I));",";
Print Str$(D_SAMP(3,I));",";
Print Str$(D_SAMP(4,I));",";
Print Str$(D_SAMP(5,I))
EndIf
Next I
End Sub

Function DATE_TIME_STRING(T As INTEGER) As STRING


DATE_TIME_STRING = Str$(T\86400,6,0)+"."+Str$((((T Mod 86400)*1000000)\86400),6,0,"0")
End Function

Sub DO_I_CAL(I_NUM As INTEGER)
Local I_ENTERED As FLOAT
Local NEW_CAL As FLOAT
Local ACTUAL_NOW As FLOAT
ACTUAL_NOW=Abs(ACTUAL(I_NUM+1))
If Abs(ACTUAL_NOW) < 0.00001 Then MessageBox("I TOO LOW","Check and retry") : Exit Sub
CLS (BG_COL)
If RAW_ACTUAL(1) < 800000 Then MessageBox("INPUT V TOO LOW","Check and retry") : Exit Sub
I_ENTERED=NUMBERPAD("Enter I(A)")
If I_ENTERED < 0.000001 Then Exit Sub
NEW_CAL = I_ENTERED/ACTUAL_NOW
Text 160,10,"New I("+Str$(I_NUM)+") factor:",CT,8,1,FG_COL,BG_COL
Text 160,40,"I factor:",RT,1,1,FG_COL,BG_COL
Text 160,40,Str$(NEW_CAL),LT,1,1,FG_COL,BG_COL
If OK_CANCEL_BUTTONS() > 0 Then

I_CAL(I_NUM)=-NEW_CAL
VAR SAVE I_CAL()
EndIf
End Sub

Sub DO_V_CAL
Local V_ENTERED As FLOAT
Local ACTUAL_NOW(5) As FLOAT
Local NEW_CAL(5) As FLOAT
Local NEW_MIN,NEW_MAX As FLOAT
CLS (BG_COL)
ACTUAL_NOW(1)=RAW_ACTUAL(1)
ACTUAL_NOW(2)=RAW_ACTUAL(3)
ACTUAL_NOW(3)=RAW_ACTUAL(4)
ACTUAL_NOW(4)=RAW_ACTUAL(5)

If ACTUAL_NOW(1) < 800000 Then MessageBox("INPUT V TOO LOW","Check and retry") : Exit Sub
If ACTUAL_NOW(2) < 800000 Then MessageBox("INPUT V TOO LOW","Check and retry") : Exit Sub
If ACTUAL_NOW(3) < 800000 Then MessageBox("INPUT V TOO LOW","Check and retry") : Exit Sub
If ACTUAL_NOW(4) < 800000 Then MessageBox("INPUT V TOO LOW","Check and retry") : Exit Sub
V_ENTERED=NUMBERPAD("Enter Voltage")
If V_ENTERED < 5.0 Then MessageBox("ENTERED V TOO LOW","Check and retry") : Exit Sub
NEW_CAL(1)=V_ENTERED/ACTUAL_NOW(1)





NEW_CAL(2)=NEW_CAL(1)*I_RATIO(2)
NEW_CAL(3)=NEW_CAL(1)*I_RATIO(3)
NEW_CAL(4)=NEW_CAL(1)*I_RATIO(4)
NEW_MIN=NEW_CAL(1)
If NEW_CAL(2)<NEW_MIN Then NEW_MIN=NEW_CAL(2)
If NEW_CAL(3)<NEW_MIN Then NEW_MIN=NEW_CAL(3)
If NEW_CAL(4)<NEW_MIN Then NEW_MIN=NEW_CAL(4)
NEW_MAX=NEW_CAL(1)
If NEW_CAL(2)>NEW_MAX Then NEW_MAX=NEW_CAL(2)
If NEW_CAL(3)>NEW_MAX Then NEW_MAX=NEW_CAL(3)
If NEW_CAL(4)>NEW_MAX Then NEW_MAX=NEW_CAL(4)
CLS (BG_COL)
Text 160,10,"New V factors:",CT,8,1,FG_COL,BG_COL
Text 160,40,"V1 factor:",RT,1,1,FG_COL,BG_COL
Text 160,60,"V2 factor:",RT,1,1,FG_COL,BG_COL
Text 160,80,"V3 factor:",RT,1,1,FG_COL,BG_COL
Text 160,100,"V4 factor:",RT,1,1,FG_COL,BG_COL
Text 160,120,"Variation:",RT,1,1,FG_COL,BG_COL
Text 160,40,Str$(NEW_CAL(1)),LT,1,1,FG_COL,BG_COL
Text 160,60,Str$(NEW_CAL(2)),LT,1,1,FG_COL,BG_COL
Text 160,80,Str$(NEW_CAL(3)),LT,1,1,FG_COL,BG_COL
Text 160,100,Str$(NEW_CAL(4)),LT,1,1,FG_COL,BG_COL
Text 160,120,Str$(((NEW_MAX-NEW_MIN)*100)/NEW_MAX)+"%",LT,1,1,FG_COL,BG_COL

If OK_CANCEL_BUTTONS() > 0 Then

V_CAL(1)=NEW_CAL(1)
V_CAL(2)=NEW_CAL(2)
V_CAL(3)=NEW_CAL(3)
V_CAL(4)=NEW_CAL(4)
VAR SAVE V_CAL()
EndIf
End Sub

Sub DRAW_CALIBRATE
CLS (BG_COL)
Text 160,10,"CALIBRATE",CT,8,1,FG_COL,BG_COL
Text 160,40,"V factor:",RT,1,1,FG_COL,BG_COL
Text 160,60,"I1 factor:",RT,1,1,FG_COL,BG_COL
Text 160,80,"I2 factor:",RT,1,1,FG_COL,BG_COL
Text 160,100,"I3 factor:",RT,1,1,FG_COL,BG_COL
Text 160,120,"I4 factor:",RT,1,1,FG_COL,BG_COL

Text 160,40,Str$(V_CAL(1)),LT,1,1,FG_COL,BG_COL
Text 160,60,Str$(I_CAL(1)),LT,1,1,FG_COL,BG_COL
Text 160,80,Str$(I_CAL(2)),LT,1,1,FG_COL,BG_COL
Text 160,100,Str$(I_CAL(3)),LT,1,1,FG_COL,BG_COL
Text 160,120,Str$(I_CAL(4)),LT,1,1,FG_COL,BG_COL

DrawButton 0, 0, 20, 140, 80, 40, BUTTON_COL, "Volts"
DrawButton 1, 0, 120, 140, 80, 40, BUTTON_COL, "Current 1"
DrawButton 2, 0, 220, 140, 80, 40, BUTTON_COL, "Current 2"
DrawButton 3, 0, 20, 190, 80, 40, BUTTON_COL, "Current 3"
DrawButton 4, 0, 120, 190, 80, 40, BUTTON_COL, "Current 4"
DrawButton 5, 0, 220, 190, 80, 40, BUTTON_COL, "Back"
End Sub

Sub DRAW_SETTINGS
CLS (BG_COL)
Text 160,5,"SETTINGS",CT,8,1,FG_COL,BG_COL
DrawButton 0, 0, 20, 45, 80, 25, BUTTON_COL, "Year"
DrawButton 1, 0, 120, 45, 80, 25, BUTTON_COL, "Month"
DrawButton 2, 0, 220, 45, 80, 25, BUTTON_COL, "Day"
DrawButton 3, 0, 20, 75, 80, 25, BUTTON_COL, "Hour"
DrawButton 4, 0, 120, 75, 80, 25, BUTTON_COL, "Minute"
DrawButton 5, 0, 220, 75, 80, 25, BUTTON_COL, "Second"
DrawButton 6, 0, 20, 105, 80, 25, BUTTON_COL, "B/L"
DrawButton 7, 0, 120, 105, 80, 25, BUTTON_COL, "V(Full)"
DrawButton 8, 0, 220, 105, 80, 25, BUTTON_COL, "Timeout"
DrawButton 9, 0, 20, 150, 80, 25, BUTTON_COL, "B/L (dim)"
DrawButton 10, 0, 120, 150, 80, 25, BUTTON_COL,"V(empty)"
DrawButton 12, 0, 20, 195, 80, 25, BUTTON_COL, "I scale"
DrawButton 13, 0, 120, 195, 80, 25, BUTTON_COL,"V(sdown)"
DrawButton 11, 0, 220, 150, 80, 70, BUTTON_COL, "BACK"
Text 60,132,Str$(ON_BL)+"%",CT,1,1,FG_COL,BG_COL
Text 160,132,Str$(V_FULL,3,2)+"V",CT,1,1,FG_COL,BG_COL
Text 260,132,Str$((MN_TMOUT+IDLE_TIMEOUT)\1000)+"s",CT,1,1,FG_COL,BG_COL

Text 60,177,Str$(IDLE_BL)+"%",CT,1,1,FG_COL,BG_COL
Text 160,177,Str$(V_EMPTY,3,2)+"V",CT,1,1,FG_COL,BG_COL

Text 60,222,Str$(I_SCALE,4,1)+"A",CT,1,1,FG_COL,BG_COL
Text 160,222,Str$(V_SHUTDOWN,3,2)+"V",CT,1,1,FG_COL,BG_COL
End Sub

Sub DRAW_DATA
CLS (BG_COL)
Text 160,10,"DATA",CT,8,1,FG_COL,BG_COL
DrawButton 0, 0, 5, 210, 70, 24, BUTTON_COL, "Hours"
DrawButton 1, 0, 85, 210, 70, 24, BUTTON_COL, "Days"
DrawButton 2, 0, 165, 210, 70, 24, BUTTON_COL, "Weeks"
DrawButton 3, 0, 245, 210, 70, 24, BUTTON_COL, "Exit"
DrawButton 4, 0, 245, 6, 70, 24, BUTTON_COL, "Export"
End Sub

Sub DRAW_MAIN
CLS (BG_COL)
Text 160,10,"SILICON CHIP",CT,8,1,FG_COL,BG_COL
Text 160,40,"BATTERY MULTI-LOGGER",CT,8,1,FG_COL,BG_COL
DrawButton 0, 0, 20, 190, 80, 40, BUTTON_COL, "Data"
DrawButton 1, 0, 120, 190, 80, 40, BUTTON_COL, "Settings"
DrawButton 2, 0, 220, 190, 80, 40, BUTTON_COL, "Calibrate"
DISPLAY_TIMEOUT=Timer
End Sub

Function SAMPLE_PATTERN(S As INTEGER)

SAMPLE_PATTERN=1
If S=2 Or S=3 Then SAMPLE_PATTERN=2
If S=6 Or S=7 Then SAMPLE_PATTERN=3
If S=10 Or S=11 Then SAMPLE_PATTERN=4
End Function

Sub SAMPLE_MANAGER
Static INTEGER SAMPLE_STATE=0









Static INTEGER SAMPLE_TIMEOUT=0
Static INTEGER LAST_SAMPLE_STATE=0
Local FLOAT NEW_ACTUAL(6)
Select Case SAMPLE_STATE

Case 0,2,4,6,8,10,12
START_ADC(SAMPLE_PATTERN(SAMPLE_STATE))
SAMPLE_TIMEOUT=Timer
SAMPLE_STATE=SAMPLE_STATE+1

Case 1,3,5,7,9,11,13
If CHECK_ADC_DONE(SAMPLE_PATTERN(SAMPLE_STATE)) > 0 Then
NEW_RAW((SAMPLE_STATE+1)\2)=GET_ADC_RESULT()
SAMPLE_STATE=SAMPLE_STATE+1
ElseIf (Timer-SAMPLE_TIMEOUT)> ADC_TIMEOUT Then
NEW_RAW(1)=-1
SAMPLE_STATE=SAMPLE_STATE+1
EndIf

Case 14
NEW_RAW(8)=Pin(SHUNT_ADC)
If  NEW_RAW(1)<0 Then

Else
RAW_ACTUAL(1)=(NEW_RAW(1)+NEW_RAW(3)+NEW_RAW(5)+NEW_RAW(7))\4
RAW_ACTUAL(3)=NEW_RAW(2)
RAW_ACTUAL(4)=NEW_RAW(4)
RAW_ACTUAL(5)=NEW_RAW(6)

If NEW_RAW(2)>800000 Then I_RATIO(2)=(NEW_RAW(1)+NEW_RAW(3))/(NEW_RAW(2)*2) Else I_RATIO(2)=1
If NEW_RAW(4)>800000 Then I_RATIO(3)=(NEW_RAW(3)+NEW_RAW(5))/(NEW_RAW(4)*2) Else I_RATIO(3)=1
If NEW_RAW(6)>800000 Then I_RATIO(4)=(NEW_RAW(5)+NEW_RAW(7))/(NEW_RAW(6)*2) Else I_RATIO(4)=1



NEW_ACTUAL(1)=(NEW_RAW(1)+NEW_RAW(3)+NEW_RAW(5)+NEW_RAW(7))*V_CAL(1)/4
NEW_ACTUAL(2)=NEW_RAW(8)*I_CAL(1)
NEW_ACTUAL(3)=(((NEW_RAW(1)+NEW_RAW(3))*V_CAL(1)/2)-(NEW_RAW(2))*V_CAL(2))*I_CAL(2)
NEW_ACTUAL(4)=(((NEW_RAW(3)+NEW_RAW(5))*V_CAL(1)/2)-(NEW_RAW(4))*V_CAL(3))*I_CAL(3)
NEW_ACTUAL(5)=(((NEW_RAW(5)+NEW_RAW(7))*V_CAL(1)/2)-(NEW_RAW(6))*V_CAL(4))*I_CAL(4)




ACTUAL(1)=NEW_ACTUAL(1)
ACTUAL(2)=NEW_ACTUAL(2)
ACTUAL(3)=NEW_ACTUAL(3)
ACTUAL(4)=NEW_ACTUAL(4)
ACTUAL(5)=NEW_ACTUAL(5)






EndIf

NEW_RAW(1)=0
START_ADC(1)
SAMPLE_TIMEOUT=Timer
SAMPLE_STATE=1
DATA_MANAGER
End Select


End Sub

Sub DATA_MANAGER
Local INTEGER S_PERIODS
Local FLOAT AH_NOW, WH_NOW
Local INTEGER S_NUM
Local INTEGER I,J,NEW_H_PTR
Local FLOAT DATA_BUFFER(6)
Local INTEGER DATA_COUNT
S_NUM=(TIME_SERIAL()\5) Mod 720


S_PERIODS=(S_NUM + 720 - SAMPLE_STATE) Mod 720
If RAW_ACTUAL(1)>=0 Then
AH_NOW = (ACTUAL(2)+ACTUAL(3)+ACTUAL(4)+ACTUAL(5)) * S_PERIODS / 720
AH_SINCEF = AH_SINCEF + AH_NOW
AH_SINCEE = AH_SINCEE + AH_NOW
WH_NOW = AH_NOW * ACTUAL(1)
WH_SINCEF = WH_SINCEF + WH_NOW
WH_SINCEE = WH_SINCEE + WH_NOW
If ACTUAL(1) < V_EMPTY Then
AH_SINCEE=0
WH_SINCEE=0
USAGE_STATE = USAGE_STATE Or &H1
EndIf
If ACTUAL(1) > V_FULL Then
AH_SINCEF=0
WH_SINCEF=0
USAGE_STATE = USAGE_STATE Or &H2
EndIf
EndIf
If SAMPLE_STATE < S_NUM Then



For J= SAMPLE_STATE+1 To S_NUM
SAMPLES(1,J)=-1
Next J

For I=1 To 5
SAMPLES(I,S_NUM)=ACTUAL(I)
Next I
SAMPLE_STATE=S_NUM
EndIf
If S_NUM < SAMPLE_STATE Then
SAMPLE_STATE=0

For I = 1 To 5
DATA_BUFFER(I)=0
Next I
DATA_COUNT=0
For J = 1 To 720
If SAMPLES(1,J)>0 Then
For I = 1 To 5
DATA_BUFFER(I)=DATA_BUFFER(I)+SAMPLES(I,J)
Next I
DATA_COUNT=DATA_COUNT+1
EndIf
Next J
If DATA_COUNT>0 Then

If H_START=0 Then
H_START=TIME_SERIAL()\3600
H_PTR=0
Else
NEW_H_PTR=(TIME_SERIAL()\3600)-H_START

If NEW_H_PTR >= H_COUNT Then NEW_H_PTR=ARCHIVE_HOUR_DATA(NEW_H_PTR)
H_PTR=NEW_H_PTR
EndIf
For I = 1 To 5
H_SAMP(I,H_PTR)=DATA_BUFFER(I)/DATA_COUNT
Next I
VAR SAVE H_PTR,H_START,H_SAMP()


Else

EndIf
If (((TIME_SERIAL()\3600) Mod 24) = 0) Then DAY_DATA_MANAGER
EndIf

End Sub

Sub DAY_DATA_MANAGER
Local INTEGER I,J,NEW_D_PTR
Local FLOAT DATA_BUFFER(6)
Local INTEGER DATA_COUNT
Local INTEGER H_TO_START, H_TO_END
H_TO_START  = (TIME_SERIAL()\3600)-24-H_START
H_TO_END = H_TO_START+23
If H_TO_START < 0 Then H_TO_START = 0
If H_TO_END > H_COUNT-1 Then H_TO_END = H_COUNT-1
If H_TO_END < H_TO_START Then

Exit Sub
EndIf
For I = 1 To 5
DATA_BUFFER(I)=0
Next I
DATA_COUNT=0
For J = H_TO_START To H_TO_END
If H_SAMP(1,J)>0 Then
For I = 1 To 5
DATA_BUFFER(I)=DATA_BUFFER(I)+H_SAMP(I,J)
Next I
DATA_COUNT=DATA_COUNT+1
EndIf
Next J

If DATA_COUNT>0 Then
If D_START=0 Then
D_START=TIME_SERIAL()\86400
D_PTR=0
Else
NEW_D_PTR=(TIME_SERIAL()\86400)-D_START

If NEW_D_PTR >= D_COUNT Then NEW_D_PTR=ARCHIVE_DAY_DATA(NEW_D_PTR)
D_PTR=NEW_D_PTR
EndIf
For I = 1 To 5
D_SAMP(I,D_PTR)=DATA_BUFFER(I)/DATA_COUNT
Next I
VAR SAVE D_PTR,D_START,D_SAMP()

Else

EndIf
End Sub

Function ARCHIVE_DAY_DATA(D As INTEGER) As INTEGER
ARCHIVE_DAY_DATA = D
If D < D_COUNT Then Exit Function
Local INTEGER OFFSET,I,J
OFFSET = D - D_COUNT + 1
For J = 0 To D_COUNT - OFFSET - 1
For I = 1 To 5
D_SAMP(I,J)=D_SAMP(I,J+OFFSET)
Next I
Next J
D_START=D_START+OFFSET
ARCHIVE_DAY_DATA=D_COUNT-1

End Function


Function ARCHIVE_HOUR_DATA(H As INTEGER) As INTEGER
ARCHIVE_HOUR_DATA = H
If H < H_COUNT Then Exit Function
Local INTEGER OFFSET,I,J
OFFSET = H - H_COUNT + 1
For J = 0 To H_COUNT - OFFSET - 1
For I = 1 To 5
H_SAMP(I,J)=H_SAMP(I,J+OFFSET)
Next I
Next J
H_START=H_START+OFFSET

ARCHIVE_HOUR_DATA=H_COUNT-1

End Function

Function TIME_SERIAL() As INTEGER
Local INTEGER T(6)
T(0)=Val(Mid$(Date$,7,4))
T(1)=Val(Mid$(Date$,4,2))
T(2)=Val(Mid$(Date$,1,2))
T(3)=Val(Mid$(Time$,1,2))
T(4)=Val(Mid$(Time$,4,2))
T(5)=Val(Mid$(Time$,7,2))
TIME_SERIAL=TIME_SERIAL+T(2)+1
If T(1)=12 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+334
If T(1)=11 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+304
If T(1)=10 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+273
If T(1)=9 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+243
If T(1)=8 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+212
If T(1)=7 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+181
If T(1)=6 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+151
If T(1)=5 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+120
If T(1)=4 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+90
If T(1)=3 Then TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+59
If T(1)=2 Then TIME_SERIAL=TIME_SERIAL+31

Do While(T(0)>1900)
T(0)=T(0)-1
TIME_SERIAL=TIME_SERIAL+365+IS_LEAP_YEAR(T(0))
Loop
TIME_SERIAL=TIME_SERIAL*86400+T(3)*3600+T(4)*60+T(5)
End Function

Function IS_LEAP_YEAR(Y As INTEGER) As INTEGER
IS_LEAP_YEAR=0
If ((Y\4)*4)=Y Then IS_LEAP_YEAR =1
If ((Y\100)*100)=Y Then IS_LEAP_YEAR =0
If ((Y\400)*400)=Y Then IS_LEAP_YEAR =1
End Function

Sub WAIT_FOR_RELEASE
Do While (CHECK_SCREEN_TOUCH()=1)
Pause 100
Loop
End Sub

Function CHECK_SCREEN_TOUCH() As INTEGER
Local PIN_10_SAVE As INTEGER
PIN_10_SAVE=Pin(10)
Pin(10)=1
CHECK_SCREEN_TOUCH=0
If (Pin(15)=0) Then CHECK_SCREEN_TOUCH=1
Pin(10)=PIN_10_SAVE
End Function

Sub SET_BACKLIGHT(B As INTEGER)
PWM 2,50000,B

End Sub

Sub LCD_ON
SetPin 10,DOUT
Pin(10)=1
GUI RESET LCDPANEL
End Sub

Sub LCD_OFF

Poke word &hBF886034,9
Poke word &hBF886134,36876

End Sub

Sub START_ADC(C As INTEGER)
Local INTEGER CHANNEL_MASK,JUNK,TMOUT
CHANNEL_MASK=0



SPI OPEN 2000000, 3, 8
If C = 1 Then CHANNEL_MASK=&h10
If C = 2 Then CHANNEL_MASK=&h20
If C = 3 Then CHANNEL_MASK=&h40
If C = 4 Then CHANNEL_MASK=&h80
Pin(ADC_CS)=0

JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
Pin(ADC_CS)=1
Pin(ADC_CS)=0
JUNK=SPI(8)
JUNK=SPI(&h38)
JUNK=SPI(&h07)
JUNK=SPI(&hFF)
Pin(ADC_CS)=1
Pin(ADC_CS)=0
JUNK=SPI(16)
JUNK=SPI(&H00)
JUNK=SPI(CHANNEL_MASK)
JUNK=SPI(&H48)
Pin(ADC_CS)=1
SPI CLOSE

End Sub

Function CHECK_ADC_DONE(C As INTEGER) As INTEGER
Local INTEGER JUNK
CHECK_ADC_DONE=0



SPI OPEN 2000000, 3, 8
Pin(ADC_CS)=0
JUNK=SPI(64)
JUNK=SPI(0)
Pin(ADC_CS)=1
If (JUNK And 7) = (C+3) Then CHECK_ADC_DONE=1
SPI CLOSE

End Function

Function GET_ADC_RESULT() As INTEGER
Local INTEGER JUNK
GET_ADC_RESULT=-1



SPI OPEN 2000000, 3, 8
Pin(ADC_CS)=0
JUNK=SPI(88)
GET_ADC_RESULT=SPI(0)*65536
GET_ADC_RESULT=GET_ADC_RESULT + SPI(0)*256
GET_ADC_RESULT=GET_ADC_RESULT + SPI(0)
Pin(ADC_CS)=1

SPI CLOSE

End Function

Function GET_ADC(C As INTEGER) As FLOAT
GET_ADC=-1
Local INTEGER CHANNEL_MASK,JUNK,TMOUT
TMOUT=2000
CHANNEL_MASK=0



SPI OPEN 2000000, 3, 8
If C = 1 Then CHANNEL_MASK=&h10
If C = 2 Then CHANNEL_MASK=&h20
If C = 3 Then CHANNEL_MASK=&h40
If C = 4 Then CHANNEL_MASK=&h80
Pin(ADC_CS)=0

JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
Pin(ADC_CS)=1
Pin(ADC_CS)=0
JUNK=SPI(8)
JUNK=SPI(&h38)
JUNK=SPI(&h07)
JUNK=SPI(&hFF)
Pin(ADC_CS)=1
Pin(ADC_CS)=0
JUNK=SPI(16)
JUNK=SPI(&H00)
JUNK=SPI(CHANNEL_MASK)
JUNK=SPI(&H48)
Pin(ADC_CS)=1
Do While(TMOUT>0)
Pin(ADC_CS)=0
JUNK=SPI(64)
JUNK=SPI(0)
Pin(ADC_CS)=1

If (JUNK And 7) = (C+3) Then
TMOUT=-1
Pin(ADC_CS)=0
JUNK=SPI(88)
GET_ADC=SPI(0)*65536
GET_ADC=GET_ADC + SPI(0)*256
GET_ADC=GET_ADC + SPI(0)
Pin(ADC_CS)=1
End If
Pause 100
TMOUT=TMOUT-100
Loop







SPI CLOSE

End Function


Function GET_ADC_FAST(C As INTEGER) As FLOAT
GET_ADC_FAST=-1000000
Local INTEGER CHANNEL_MASK,JUNK,TMOUT
TMOUT=200
CHANNEL_MASK=0



SPI OPEN 2000000, 3, 8
If C = 1 Then CHANNEL_MASK=&h10
If C = 2 Then CHANNEL_MASK=&h20
If C = 3 Then CHANNEL_MASK=&h40
If C = 4 Then CHANNEL_MASK=&h80
Pin(ADC_CS)=0

JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
JUNK=SPI(255)
Pin(ADC_CS)=1
Pin(ADC_CS)=0
JUNK=SPI(8)
JUNK=SPI(&h38)
JUNK=SPI(&h00)
JUNK=SPI(32)
Pin(ADC_CS)=1
Pin(ADC_CS)=0
JUNK=SPI(16)
JUNK=SPI(&H00)
JUNK=SPI(CHANNEL_MASK)
JUNK=SPI(&H48)
Pin(ADC_CS)=1
Do While(TMOUT>0)
Pin(ADC_CS)=0
JUNK=SPI(64)
JUNK=SPI(0)
Pin(ADC_CS)=1

If (JUNK And 7) = (C+3) Then
TMOUT=-1
Pin(ADC_CS)=0
JUNK=SPI(88)
GET_ADC_FAST=SPI(0)*65536
GET_ADC_FAST=GET_ADC_FAST + SPI(0)*256
GET_ADC_FAST=GET_ADC_FAST + SPI(0)
Pin(ADC_CS)=1
End If
Pause 10
TMOUT=TMOUT-10
Loop







SPI CLOSE

End Function





















Sub DrawButton n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
Local Integer bc, fc

If mode = 0 Then
key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
key_coord(n,4) = c : key_caption(n) = s
EndIf

If mode > 1 Then
bc = key_coord(n,4) : fc = 0
Else
bc = 0 : fc = key_coord(n,4)
EndIf

RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, , , fc, bc
End Sub

Function CheckButtonPress2(startn As Integer, endn As Integer) As Integer
CheckButtonPress = -1

End Function



Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
Local Integer xt, yellowt, n

CheckButtonPress = -1
If Touch(x) <> -1 Then


xt = Touch(x)
yellowt = Touch(y)


For n = startn To endn
If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then


DrawButton n, 2
CheckButtonPress = n
Exit For
EndIf
Next n
EndIf
End Function



Sub CheckButtonRelease n As Integer

Do While Touch(x) <> -1
SAMPLE_MANAGER
Loop
DrawButton n, 1
End Sub







Sub MessageBox s1 As String, s2 As String
Local Integer w
If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
w = w * 8


RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , FG_COL, 0
Text MM.HRes/2, 70, s1, CT, 1, 2, FG_COL
Text MM.HRes/2, 100, s2, CT, 1, 2, FG_COL


RBox 110, 140, 100, 34, , BUTTON_COL
Text MM.HRes/2, 157, "OK", CM, 1, 2, BUTTON_COL



Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop


RBox 110, 140, 100, 34, , BUTTON_COL, BUTTON_COL
Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, BUTTON_COL


Do While Touch(x) <> -1 : Loop
End Sub

Function OK_CANCEL_BOX(S1 As STRING, S2 As STRING) As INTEGER
OK_CANCEL_BOX=0
Local Integer w
If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
w = w * 8
If w < 108 Then w = 108


RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , FG_COL, 0
Text MM.HRes/2, 70, s1, CT, 1, 2, FG_COL
Text MM.HRes/2, 100, s2, CT, 1, 2, FG_COL


RBox 55, 140, 100, 34, , BUTTON_COL
Text 105, 157, "OK", CM, 1, 2, BUTTON_COL

RBox 165, 140, 100, 34, , BUTTON_COL
Text 215, 157, "CANCEL", CM, 1, 2, BUTTON_COL

Do
SAMPLE_MANAGER
If  (Touch(y) > 140 And Touch(y) < 180) Then
If (Touch(x)>55 And Touch(x)<155) Then
RBox 55, 140, 100, 34, , BUTTON_COL, BUTTON_COL
Text 105, 157, "OK", CM, 1, 2, 0, BUTTON_COL
Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
OK_CANCEL_BOX=1
Exit Function
EndIf
If (Touch(x)>165 And Touch(x)<265) Then
RBox 165, 140, 100, 34, , BUTTON_COL, BUTTON_COL
Text 215, 157, "CANCEL", CM, 1, 2, 0, BUTTON_COL
Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
OK_CANCEL_BOX=0
Exit Function
EndIf
EndIf
Loop

End Function

Function OK_CANCEL_BUTTONS() As INTEGER
OK_CANCEL_BUTTONS=0

RBox 55, 200, 100, 34, , BUTTON_COL
Text 105, 217, "OK", CM, 1, 2, BUTTON_COL

RBox 165, 200, 100, 34, , BUTTON_COL
Text 215, 217, "CANCEL", CM, 1, 2, BUTTON_COL

Do
SAMPLE_MANAGER
If  (Touch(y) > 200 And Touch(y) < 240) Then
If (Touch(x)>55 And Touch(x)<155) Then
RBox 55, 200, 100, 34, , BUTTON_COL, BUTTON_COL
Text 105, 217, "OK", CM, 1, 2, 0, BUTTON_COL
Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
OK_CANCEL_BUTTONS=1
Exit Function
EndIf
If (Touch(x)>165 And Touch(x)<265) Then
RBox 165, 200, 100, 34, , BUTTON_COL, BUTTON_COL
Text 215, 217, "CANCEL", CM, 1, 2, 0, BUTTON_COL
Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
OK_CANCEL_BUTTONS=0
Exit Function
EndIf
EndIf
Loop
End Function

Sub DRAW_NUMPAD(BUTTON_START As INTEGER,TITLE As STRING)
CLS (BG_COL)
DrawButton BUTTON_START,0, 66, 195, 60, 40, BUTTON_COL, "0"
DrawButton BUTTON_START+1,0, 130, 195, 60, 40, BUTTON_COL, "1"
DrawButton BUTTON_START+2,0, 194, 195, 60, 40, BUTTON_COL, "2"
DrawButton BUTTON_START+3,0, 258, 195, 60, 40, BUTTON_COL, "3"
DrawButton BUTTON_START+4,0, 130, 150, 60, 40, BUTTON_COL, "4"
DrawButton BUTTON_START+5,0, 194, 150, 60, 40, BUTTON_COL, "5"
DrawButton BUTTON_START+6,0, 258, 150, 60, 40, BUTTON_COL, "6"
DrawButton BUTTON_START+7,0, 130, 105, 60, 40, BUTTON_COL, "7"
DrawButton BUTTON_START+8,0, 194, 105, 60, 40, BUTTON_COL, "8"
DrawButton BUTTON_START+9,0, 258, 105, 60, 40, BUTTON_COL, "9"
DrawButton BUTTON_START+10,0, 66, 150, 60, 40, BUTTON_COL, "."

DrawButton BUTTON_START+11,0, 2, 195, 60, 40, BUTTON_COL, "<-"
DrawButton BUTTON_START+12,0, 2, 150, 60, 40, BUTTON_COL, "OK"
DrawButton BUTTON_START+13,0, 2, 105, 60, 40, BUTTON_COL, "Cancel"
Text 160,10,TITLE,CT,8,1,FG_COL,BG_COL

End Sub


Function NUMBERPAD(TITLE As STRING) As FLOAT
NUMBERPAD=-1
Local STRING ENTRY
ENTRY=""

Local INTEGER BUTTON_START
BUTTON_START=BUTTON_COUNT-15
DRAW_NUMPAD(BUTTON_START,TITLE)
Do
SAMPLE_MANAGER
BUTTON_PRESS=CheckButtonPress(BUTTON_START, BUTTON_START+13)
If BUTTON_PRESS >= 0 Then
CheckButtonRelease(BUTTON_PRESS)
If BUTTON_PRESS = BUTTON_START Then ENTRY=ENTRY+"0"
If BUTTON_PRESS = BUTTON_START+1 Then ENTRY=ENTRY+"1"
If BUTTON_PRESS = BUTTON_START+2 Then ENTRY=ENTRY+"2"
If BUTTON_PRESS = BUTTON_START+3 Then ENTRY=ENTRY+"3"
If BUTTON_PRESS = BUTTON_START+4 Then ENTRY=ENTRY+"4"
If BUTTON_PRESS = BUTTON_START+5 Then ENTRY=ENTRY+"5"
If BUTTON_PRESS = BUTTON_START+6 Then ENTRY=ENTRY+"6"
If BUTTON_PRESS = BUTTON_START+7 Then ENTRY=ENTRY+"7"
If BUTTON_PRESS = BUTTON_START+8 Then ENTRY=ENTRY+"8"
If BUTTON_PRESS = BUTTON_START+9 Then ENTRY=ENTRY+"9"
If (BUTTON_PRESS = BUTTON_START+10) And (Instr(ENTRY,".") = 0)Then ENTRY=ENTRY+"."
If (BUTTON_PRESS = BUTTON_START+11) And (Len(ENTRY)>0) Then ENTRY=Left$(ENTRY,Len(ENTRY)-1)
If ENTRY="." Then ENTRY="0."
If Len(ENTRY)>9 Then ENTRY=Left$(ENTRY,9)
If BUTTON_PRESS = BUTTON_START+13 Then NUMBERPAD=-1: Exit Function
If BUTTON_PRESS = BUTTON_START+12 Then
NUMBERPAD=Val(ENTRY)
If OK_CANCEL_BOX("ACCEPT?",Str$(NUMBERPAD))>0 Then Exit Function

NUMBERPAD=-1
DRAW_NUMPAD(BUTTON_START,TITLE)
EndIf
EndIf
Text 0,45,Right$("               "+ENTRY+"_",10),LT,8,2,FG_COL,HL_COLOUR
Loop

End Function                   